/*
	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License version 2 
	as published by the Free Software Foundation.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

	Copyright (C) 2006  Thierry Berger-Perrin <tbptbp@gmail.com>
*/
#ifndef MATH_UTILITY_H
#define MATH_UTILITY_H

/* We will poll cmath/math.h in from here */
#define _USE_MATH_DEFINES
#include <cmath>
#include "specifics.h"

static FINLINE float minf(const float a, const float b) { return (b > a) ? a : b; }
static FINLINE float maxf(const float a, const float b) { return (b < a) ? a : b; }
static FINLINE float clampf(const float minima, const float maxima, const float value) { return minf(maxf(value, minima), maxima); }
static FINLINE void clampf(const float minima, const float maxima, const float value, float &output) { output = minf(maxf(value, minima), maxima); }

// Returns an integer going through <0,amplitude-1,0> with a (2*amplitude)-1 frequency
template <int amplitude> static int compute_cyclic(const int val) {
	enum { amp = amplitude-1, bias = amp, freq = 2*amp };
	return abs(amp - ((val+bias) % freq));
}

// Mapped back to [0, 1]
template <int amplitude> static float compute_cyclicf(const int val) {
	enum { amp = amplitude-1, bias = amp, freq = 2*amp };
	return float(compute_cyclic<amplitude>(val))/float(amp);
}

// Should really put that into the constant section,
// but then we don't have much use for it so...
#ifndef M_PI
	#define M_PI	3.14159265358979323846
#endif

#define DEGRAD(a)	((a) * (float(M_PI) / 180.f))
#define RADDEG(a)	((a) * (180.f/ float(M_PI)))

#endif
